// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Incustomhttpserver.pas' rev: 10.00

#ifndef IncustomhttpserverHPP
#define IncustomhttpserverHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Inassignednumbers.hpp>	// Pascal unit
#include <Incontext.hpp>	// Pascal unit
#include <Inexception.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit
#include <Instack.hpp>	// Pascal unit
#include <Inexceptioncore.hpp>	// Pascal unit
#include <Inglobalprotocols.hpp>	// Pascal unit
#include <Inheaderlist.hpp>	// Pascal unit
#include <Intcpserver.hpp>	// Pascal unit
#include <Intcpconnection.hpp>	// Pascal unit
#include <Inthread.hpp>	// Pascal unit
#include <Incookie.hpp>	// Pascal unit
#include <Inhttpheaderinfo.hpp>	// Pascal unit
#include <Instackconsts.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Incomponent.hpp>	// Pascal unit
#include <Inbasecomponent.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Incustomhttpserver
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum THTTPCommandType { hcUnknown, hcHEAD, hcGET, hcPOST, hcDELETE, hcPUT, hcTRACE, hcOPTION };
#pragma option pop

typedef AnsiString InCustomHTTPServer__1[8];

class DELPHICLASS TInHTTPSession;
typedef void __fastcall (__closure *TOnSessionEndEvent)(TInHTTPSession* Sender);

typedef void __fastcall (__closure *TOnSessionStartEvent)(TInHTTPSession* Sender);

typedef void __fastcall (__closure *TOnCreateSession)(Incontext::TInContext* ASender, TInHTTPSession* &VHTTPSession);

typedef void __fastcall (__closure *TOnCreatePostStream)(Incontext::TInContext* AContext, Classes::TStream* &VPostStream);

class DELPHICLASS TInHTTPRequestInfo;
class DELPHICLASS TInHTTPResponseInfo;
typedef void __fastcall (__closure *TInHTTPGetEvent)(Incontext::TInContext* AContext, TInHTTPRequestInfo* ARequestInfo, TInHTTPResponseInfo* AResponseInfo);

typedef void __fastcall (__closure *TInHTTPOtherEvent)(Incontext::TInContext* AContext, const AnsiString asCommand, const AnsiString asData, const AnsiString asVersion);

typedef void __fastcall (__closure *TInHTTPInvalidSessionEvent)(Incontext::TInContext* AContext, TInHTTPRequestInfo* ARequestInfo, TInHTTPResponseInfo* AResponseInfo, bool &VContinueProcessing, const AnsiString AInvalidSessionID);

class DELPHICLASS EInHTTPServerError;
class PASCALIMPLEMENTATION EInHTTPServerError : public Inexception::EInException 
{
	typedef Inexception::EInException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInHTTPServerError(AnsiString AMsg)/* overload */ : Inexception::EInException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInHTTPServerError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Inexception::EInException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInHTTPServerError(int Ident)/* overload */ : Inexception::EInException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInHTTPServerError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Inexception::EInException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInHTTPServerError(const AnsiString Msg, int AHelpContext) : Inexception::EInException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInHTTPServerError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Inexception::EInException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInHTTPServerError(int Ident, int AHelpContext)/* overload */ : Inexception::EInException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInHTTPServerError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Inexception::EInException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInHTTPServerError(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInHTTPHeaderAlreadyWritten;
class PASCALIMPLEMENTATION EInHTTPHeaderAlreadyWritten : public EInHTTPServerError 
{
	typedef EInHTTPServerError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInHTTPHeaderAlreadyWritten(AnsiString AMsg)/* overload */ : EInHTTPServerError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInHTTPHeaderAlreadyWritten(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInHTTPServerError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInHTTPHeaderAlreadyWritten(int Ident)/* overload */ : EInHTTPServerError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInHTTPHeaderAlreadyWritten(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInHTTPServerError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInHTTPHeaderAlreadyWritten(const AnsiString Msg, int AHelpContext) : EInHTTPServerError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInHTTPHeaderAlreadyWritten(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInHTTPServerError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInHTTPHeaderAlreadyWritten(int Ident, int AHelpContext)/* overload */ : EInHTTPServerError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInHTTPHeaderAlreadyWritten(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInHTTPServerError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInHTTPHeaderAlreadyWritten(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInHTTPErrorParsingCommand;
class PASCALIMPLEMENTATION EInHTTPErrorParsingCommand : public EInHTTPServerError 
{
	typedef EInHTTPServerError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInHTTPErrorParsingCommand(AnsiString AMsg)/* overload */ : EInHTTPServerError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInHTTPErrorParsingCommand(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInHTTPServerError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInHTTPErrorParsingCommand(int Ident)/* overload */ : EInHTTPServerError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInHTTPErrorParsingCommand(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInHTTPServerError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInHTTPErrorParsingCommand(const AnsiString Msg, int AHelpContext) : EInHTTPServerError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInHTTPErrorParsingCommand(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInHTTPServerError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInHTTPErrorParsingCommand(int Ident, int AHelpContext)/* overload */ : EInHTTPServerError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInHTTPErrorParsingCommand(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInHTTPServerError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInHTTPErrorParsingCommand(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInHTTPUnsupportedAuthorisationScheme;
class PASCALIMPLEMENTATION EInHTTPUnsupportedAuthorisationScheme : public EInHTTPServerError 
{
	typedef EInHTTPServerError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInHTTPUnsupportedAuthorisationScheme(AnsiString AMsg)/* overload */ : EInHTTPServerError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInHTTPUnsupportedAuthorisationScheme(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInHTTPServerError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInHTTPUnsupportedAuthorisationScheme(int Ident)/* overload */ : EInHTTPServerError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInHTTPUnsupportedAuthorisationScheme(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInHTTPServerError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInHTTPUnsupportedAuthorisationScheme(const AnsiString Msg, int AHelpContext) : EInHTTPServerError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInHTTPUnsupportedAuthorisationScheme(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInHTTPServerError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInHTTPUnsupportedAuthorisationScheme(int Ident, int AHelpContext)/* overload */ : EInHTTPServerError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInHTTPUnsupportedAuthorisationScheme(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInHTTPServerError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInHTTPUnsupportedAuthorisationScheme(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInHTTPCannotSwitchSessionStateWhenActive;
class PASCALIMPLEMENTATION EInHTTPCannotSwitchSessionStateWhenActive : public EInHTTPServerError 
{
	typedef EInHTTPServerError inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInHTTPCannotSwitchSessionStateWhenActive(AnsiString AMsg)/* overload */ : EInHTTPServerError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInHTTPCannotSwitchSessionStateWhenActive(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : EInHTTPServerError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInHTTPCannotSwitchSessionStateWhenActive(int Ident)/* overload */ : EInHTTPServerError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInHTTPCannotSwitchSessionStateWhenActive(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : EInHTTPServerError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInHTTPCannotSwitchSessionStateWhenActive(const AnsiString Msg, int AHelpContext) : EInHTTPServerError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInHTTPCannotSwitchSessionStateWhenActive(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : EInHTTPServerError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInHTTPCannotSwitchSessionStateWhenActive(int Ident, int AHelpContext)/* overload */ : EInHTTPServerError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInHTTPCannotSwitchSessionStateWhenActive(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : EInHTTPServerError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInHTTPCannotSwitchSessionStateWhenActive(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TInHTTPRequestInfo : public Inhttpheaderinfo::TIdRequestHeaderInfo 
{
	typedef Inhttpheaderinfo::TIdRequestHeaderInfo inherited;
	
protected:
	bool FAuthExists;
	Incookie::TIdServerCookies* FCookies;
	Classes::TStrings* FParams;
	Classes::TStream* FPostStream;
	AnsiString FRawHTTPCommand;
	AnsiString FRemoteIP;
	TInHTTPSession* FSession;
	AnsiString FDocument;
	AnsiString FCommand;
	AnsiString FVersion;
	AnsiString FAuthUsername;
	AnsiString FAuthPassword;
	AnsiString FUnparsedParams;
	AnsiString FQueryParams;
	AnsiString FFormParams;
	THTTPCommandType FCommandType;
	virtual void __fastcall DecodeAndSetParams(const AnsiString AValue);
	virtual void __fastcall DecodeCommand(void);
	
public:
	__fastcall virtual TInHTTPRequestInfo(void);
	__fastcall virtual ~TInHTTPRequestInfo(void);
	__property TInHTTPSession* Session = {read=FSession};
	__property bool AuthExists = {read=FAuthExists, nodefault};
	__property AnsiString AuthPassword = {read=FAuthPassword};
	__property AnsiString AuthUsername = {read=FAuthUsername};
	__property AnsiString Command = {read=FCommand};
	__property THTTPCommandType CommandType = {read=FCommandType, nodefault};
	__property Incookie::TIdServerCookies* Cookies = {read=FCookies};
	__property AnsiString Document = {read=FDocument, write=FDocument};
	__property Classes::TStrings* Params = {read=FParams};
	__property Classes::TStream* PostStream = {read=FPostStream, write=FPostStream};
	__property AnsiString RawHTTPCommand = {read=FRawHTTPCommand};
	__property AnsiString RemoteIP = {read=FRemoteIP};
	__property AnsiString UnparsedParams = {read=FUnparsedParams, write=FUnparsedParams};
	__property AnsiString FormParams = {read=FFormParams, write=FFormParams};
	__property AnsiString QueryParams = {read=FQueryParams, write=FQueryParams};
	__property AnsiString Version = {read=FVersion};
};


class DELPHICLASS TInCustomHTTPServer;
class DELPHICLASS TInHTTPCustomSessionList;
class PASCALIMPLEMENTATION TInHTTPCustomSessionList : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	int FSessionTimeout;
	TOnSessionEndEvent FOnSessionEnd;
	TOnSessionStartEvent FOnSessionStart;
	
protected:
	virtual void __fastcall RemoveSession(TInHTTPSession* Session) = 0 ;
	
public:
	virtual void __fastcall Clear(void) = 0 ;
	virtual void __fastcall PurgeStaleSessions(bool PurgeAll = false) = 0 ;
	virtual TInHTTPSession* __fastcall CreateUniqueSession(const AnsiString RemoteIP) = 0 ;
	virtual TInHTTPSession* __fastcall CreateSession(const AnsiString RemoteIP, const AnsiString SessionID) = 0 ;
	virtual TInHTTPSession* __fastcall GetSession(const AnsiString SessionID, const AnsiString RemoteIP) = 0 ;
	virtual void __fastcall Add(TInHTTPSession* ASession) = 0 ;
	
__published:
	__property int SessionTimeout = {read=FSessionTimeout, write=FSessionTimeout, nodefault};
	__property TOnSessionEndEvent OnSessionEnd = {read=FOnSessionEnd, write=FOnSessionEnd};
	__property TOnSessionStartEvent OnSessionStart = {read=FOnSessionStart, write=FOnSessionStart};
public:
	#pragma option push -w-inl
	/* TComponent.Create */ inline __fastcall virtual TInHTTPCustomSessionList(Classes::TComponent* AOwner) : Classes::TComponent(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TInHTTPCustomSessionList(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TInCustomHTTPServer : public Intcpserver::TInTCPServer 
{
	typedef Intcpserver::TInTCPServer inherited;
	
protected:
	bool FAutoStartSession;
	bool FKeepAlive;
	bool FParseParams;
	AnsiString FServerSoftware;
	Inglobalprotocols::TIdMimeTable* FMIMETable;
	TInHTTPCustomSessionList* FSessionList;
	bool FSessionState;
	int FSessionTimeOut;
	bool FOkToProcessCommand;
	TOnCreatePostStream FOnCreatePostStream;
	TOnCreateSession FOnCreateSession;
	TInHTTPInvalidSessionEvent FOnInvalidSession;
	TOnSessionEndEvent FOnSessionEnd;
	TOnSessionStartEvent FOnSessionStart;
	TInHTTPGetEvent FOnCommandGet;
	TInHTTPOtherEvent FOnCommandOther;
	Inthread::TInThread* FSessionCleanupThread;
	int FMaximumHeaderLineCount;
	virtual void __fastcall DoOnCreateSession(Incontext::TInContext* AContext, TInHTTPSession* &VNewSession);
	virtual void __fastcall DoInvalidSession(Incontext::TInContext* AContext, TInHTTPRequestInfo* ARequestInfo, TInHTTPResponseInfo* AResponseInfo, bool &VContinueProcessing, const AnsiString AInvalidSessionID);
	virtual void __fastcall DoCommandOther(Incontext::TInContext* AContext, const AnsiString asCommand, const AnsiString asData, const AnsiString asVersion);
	virtual void __fastcall DoCommandGet(Incontext::TInContext* AContext, TInHTTPRequestInfo* ARequestInfo, TInHTTPResponseInfo* AResponseInfo);
	virtual void __fastcall CreatePostStream(Incontext::TInContext* ASender, Classes::TStream* &VPostStream);
	virtual void __fastcall DoConnect(Incontext::TInContext* AContext);
	void __fastcall DoCreatePostStream(Incontext::TInContext* ASender, Classes::TStream* &VPostStream);
	virtual bool __fastcall DoExecute(Incontext::TInContext* AContext);
	virtual void __fastcall SetActive(bool AValue);
	void __fastcall SetSessionState(const bool Value);
	TInHTTPSession* __fastcall GetSessionFromCookie(Incontext::TInContext* AContext, TInHTTPRequestInfo* AHTTPrequest, TInHTTPResponseInfo* AHTTPResponse, bool &VContinueProcessing);
	virtual void __fastcall InitComponent(void);
	__property TOnCreatePostStream OnCreatePostStream = {read=FOnCreatePostStream, write=FOnCreatePostStream};
	__property TInHTTPGetEvent OnCommandGet = {read=FOnCommandGet, write=FOnCommandGet};
	
public:
	TInHTTPSession* __fastcall CreateSession(Incontext::TInContext* AContext, TInHTTPResponseInfo* HTTPResponse, TInHTTPRequestInfo* HTTPRequest);
	__fastcall virtual ~TInCustomHTTPServer(void);
	bool __fastcall EndSession(const AnsiString SessionName);
	__property Inglobalprotocols::TIdMimeTable* MIMETable = {read=FMIMETable};
	__property TInHTTPCustomSessionList* SessionList = {read=FSessionList};
	
__published:
	__property int MaximumHeaderLineCount = {read=FMaximumHeaderLineCount, write=FMaximumHeaderLineCount, default=1024};
	__property bool AutoStartSession = {read=FAutoStartSession, write=FAutoStartSession, default=0};
	__property DefaultPort  = {default=80};
	__property TInHTTPInvalidSessionEvent OnInvalidSession = {read=FOnInvalidSession, write=FOnInvalidSession};
	__property TOnSessionStartEvent OnSessionStart = {read=FOnSessionStart, write=FOnSessionStart};
	__property TOnSessionEndEvent OnSessionEnd = {read=FOnSessionEnd, write=FOnSessionEnd};
	__property TOnCreateSession OnCreateSession = {read=FOnCreateSession, write=FOnCreateSession};
	__property bool KeepAlive = {read=FKeepAlive, write=FKeepAlive, default=0};
	__property bool ParseParams = {read=FParseParams, write=FParseParams, default=1};
	__property AnsiString ServerSoftware = {read=FServerSoftware, write=FServerSoftware};
	__property bool SessionState = {read=FSessionState, write=SetSessionState, default=0};
	__property int SessionTimeOut = {read=FSessionTimeOut, write=FSessionTimeOut, default=0};
	__property TInHTTPOtherEvent OnCommandOther = {read=FOnCommandOther, write=FOnCommandOther};
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TInCustomHTTPServer(Classes::TComponent* AOwner)/* overload */ : Intcpserver::TInTCPServer(AOwner) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TInHTTPResponseInfo : public Inhttpheaderinfo::TIdResponseHeaderInfo 
{
	typedef Inhttpheaderinfo::TIdResponseHeaderInfo inherited;
	
protected:
	AnsiString FAuthRealm;
	AnsiString FContentType;
	Intcpconnection::TInTCPConnection* FConnection;
	int FResponseNo;
	Incookie::TIdServerCookies* FCookies;
	Classes::TStream* FContentStream;
	AnsiString FContentText;
	bool FCloseConnection;
	bool FFreeContentStream;
	bool FHeaderHasBeenWritten;
	AnsiString FResponseText;
	TInCustomHTTPServer* FHTTPServer;
	TInHTTPSession* FSession;
	void __fastcall ReleaseContentStream(void);
	void __fastcall SetCookies(const Incookie::TIdServerCookies* AValue);
	virtual void __fastcall SetHeaders(void);
	void __fastcall SetResponseNo(const int AValue);
	void __fastcall SetCloseConnection(const bool Value);
	
public:
	AnsiString __fastcall GetServer();
	void __fastcall SetServer(const AnsiString Value);
	void __fastcall CloseSession(void);
	__fastcall TInHTTPResponseInfo(Intcpconnection::TInTCPConnection* AConnection, TInCustomHTTPServer* AServer);
	__fastcall virtual ~TInHTTPResponseInfo(void);
	void __fastcall Redirect(const AnsiString AURL);
	void __fastcall WriteHeader(void);
	void __fastcall WriteContent(void);
	virtual unsigned __fastcall ServeFile(Incontext::TInContext* AContext, AnsiString aFile);
	unsigned __fastcall SmartServeFile(Incontext::TInContext* AContext, TInHTTPRequestInfo* ARequestInfo, AnsiString aFile);
	__property AnsiString AuthRealm = {read=FAuthRealm, write=FAuthRealm};
	__property bool CloseConnection = {read=FCloseConnection, write=SetCloseConnection, nodefault};
	__property Classes::TStream* ContentStream = {read=FContentStream, write=FContentStream};
	__property AnsiString ContentText = {read=FContentText, write=FContentText};
	__property Incookie::TIdServerCookies* Cookies = {read=FCookies, write=SetCookies};
	__property bool FreeContentStream = {read=FFreeContentStream, write=FFreeContentStream, nodefault};
	__property bool HeaderHasBeenWritten = {read=FHeaderHasBeenWritten, write=FHeaderHasBeenWritten, nodefault};
	__property int ResponseNo = {read=FResponseNo, write=SetResponseNo, nodefault};
	__property AnsiString ResponseText = {read=FResponseText, write=FResponseText};
	__property TInCustomHTTPServer* HTTPServer = {read=FHTTPServer};
	__property AnsiString ServerSoftware = {read=GetServer, write=SetServer};
	__property TInHTTPSession* Session = {read=FSession};
};


class PASCALIMPLEMENTATION TInHTTPSession : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	Classes::TStrings* FContent;
	System::TDateTime FLastTimeStamp;
	Inglobal::TIdCriticalSection* FLock;
	TInHTTPCustomSessionList* FOwner;
	AnsiString FSessionID;
	AnsiString FRemoteHost;
	void __fastcall SetContent(const Classes::TStrings* Value);
	Classes::TStrings* __fastcall GetContent(void);
	virtual bool __fastcall IsSessionStale(void);
	virtual void __fastcall DoSessionEnd(void);
	
public:
	__fastcall virtual TInHTTPSession(TInHTTPCustomSessionList* AOwner);
	__fastcall virtual TInHTTPSession(TInHTTPCustomSessionList* AOwner, const AnsiString SessionID, const AnsiString RemoteIP);
	__fastcall virtual ~TInHTTPSession(void);
	void __fastcall Lock(void);
	void __fastcall Unlock(void);
	__property Classes::TStrings* Content = {read=GetContent, write=SetContent};
	__property System::TDateTime LastTimeStamp = {read=FLastTimeStamp};
	__property AnsiString RemoteHost = {read=FRemoteHost};
	__property AnsiString SessionID = {read=FSessionID};
};


class DELPHICLASS TInHTTPDefaultSessionList;
class PASCALIMPLEMENTATION TInHTTPDefaultSessionList : public TInHTTPCustomSessionList 
{
	typedef TInHTTPCustomSessionList inherited;
	
protected:
	Classes::TThreadList* SessionList;
	virtual void __fastcall RemoveSession(TInHTTPSession* Session);
	void __fastcall RemoveSessionFromLockedList(int AIndex, Classes::TList* ALockedSessionList);
	
public:
	__fastcall virtual TInHTTPDefaultSessionList(Classes::TComponent* AOwner);
	__fastcall virtual ~TInHTTPDefaultSessionList(void);
	virtual void __fastcall Clear(void);
	virtual void __fastcall Add(TInHTTPSession* ASession);
	virtual void __fastcall PurgeStaleSessions(bool PurgeAll = false);
	virtual TInHTTPSession* __fastcall CreateUniqueSession(const AnsiString RemoteIP);
	virtual TInHTTPSession* __fastcall CreateSession(const AnsiString RemoteIP, const AnsiString SessionID);
	virtual TInHTTPSession* __fastcall GetSession(const AnsiString SessionID, const AnsiString RemoteIP);
};


//-- var, const, procedure ---------------------------------------------------
static const bool Id_TId_HTTPServer_KeepAlive = false;
static const bool Id_TId_HTTPServer_ParseParams = true;
static const bool Id_TId_HTTPServer_SessionState = false;
static const Shortint Id_TId_HTTPSessionTimeOut = 0x0;
static const bool Id_TId_HTTPAutoStartSession = false;
static const Word Id_TId_HTTPMaximumHeaderLineCount = 0x400;
static const Byte GResponseNo = 0xc8;
static const Shortint GFContentLength = -1;
#define GServerSoftware "Indy/10.0.52"
#define GContentType "text/html"
#define GSessionInCookie "InHTTPSESSIONID"
extern PACKAGE AnsiString HTTPRequestStrings[8];

}	/* namespace Incustomhttpserver */
using namespace Incustomhttpserver;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Incustomhttpserver
